
#ifndef TgPrmtrf_h
#define TgPrmtrf_h 1

// TagParameter
#include "AbstrctR\AbstrctO\TgPrmter.h"

#define TYPE_FLOATPARAMETER float


//## Class: TagParameterInt

class TagParameterFloat : public TagParameter
{
  public:
	  virtual float getUnitValue() const;
	  void setUnit(const char *un);
	  virtual void setValue(const char *p);
	  virtual void setValue(float nval);
		TagParameterFloat(float theFloat);


		TagParameterFloat(const TagParameterFloat &tpf);

		virtual TagParameter *getCopy() const
		{
			return new TagParameterFloat(*this);
		}

		// returns success or not .
		// 1: success
		// 0: failure
		virtual int copyValue(TagParameter *tp);

		virtual ~TagParameterFloat();

		const TYPE_FLOATPARAMETER getValue(float curLSPACE=50.0) const;

		static TYPE_FLOATPARAMETER convertValue(float
			value, const char * unit,float curLSPACE=50.0);

		int TagIsUnitTag() const
		{ return unittag == 1; }

		const char * getUnit() const
		{ return unit; }
		// is one, if the tag is a unit tag 
		// (offset or width/height)
		int unittag; 

  protected:
	  char unit[3];
		TYPE_FLOATPARAMETER value;
};

// Class TagParameterInt





#endif


